# Simulate coalescent process with heterochronous sampling times

# Assumptions and modifications
# - error in sqwave traj fixed
# - single trajectory type considered
# - reorganises data so in a single folder
# - assumes fixed number of samples (elements of nSamps)
# - model selection over square waves of 2^p segments

# Clean the workspace and console
closeAllConnections(); rm(list=ls())
cat("\014"); graphics.off()

# Packages for phylodyn
library("sp"); library("devtools"); library("INLA")
library("spam"); library("ape"); library("phylodyn")

# Set working directory to source
this.dir <- dirname(parent.frame(2)$ofile)
setwd(this.dir)

# Shift time (min period of square wave)
tshift = 50; nsegs = 16
# Square wave range and numbers
frac = 0.5; nwave = log2(nsegs)+1
# Period sizes (decreasing)
tperiod = (nwave-1):0; tperiod = 2^tperiod

# Waves (define sequence of fr)
wave = matrix(1, nrow = nwave, ncol = nsegs)
nPeriods = matrix(0, 1, nwave)
for(i in 2:nwave){
  # No. periods and starting amplitude
  nPeriods[i] = nsegs/tperiod[i]
  ampLast = 1
  for(j in 1:nPeriods[i]){
    wave[i, seq((j-1)*tperiod[i]+1, j*tperiod[i])] = ampLast
    if(ampLast == 1){
      ampLast = frac
    } else {
      ampLast = 1
    }
  }
}

# No. square wave trajectories
numTraj = 200; Nmax = 600;
# Fix trajectory types
idTrajs = 1:5

# Range of sample numbers per segment to loop across 
nSamps = seq(11, 111, 10)
numRuns = length(nSamps)
# Sample times
samptimes = seq(0, (nsegs-1)*tshift, by = tshift)

# Load main function
source("sqWvFixFn.R")

# Main simulation code
for(i in idTrajs){
  sqWvFixFn(tshift, nsegs, numTraj, nwave, wave, Nmax, idTrajs[i], numRuns, nSamps, samptimes)  
}


